#!/usr/bin/python2.6

import os
import re
from datetime import datetime

import transaction
from ZODB.FileStorage import FileStorage
from ZODB.DB import DB
from zope.index.text.textindex import TextIndex

from packet import Packet


try: os.remove('data.db')
except: pass
try: os.remove('data.db.index')
except: pass
try: os.remove('data.db.lock')
except: pass
try: os.remove('data.db.tmp')
except: pass

storage = FileStorage('data.db')
db = DB(storage)
conn = db.open()
root = conn.root()
root['packets'] = {}
root['packets_index'] = index = TextIndex()


second_line = False
second_line_re = re.compile(r'^(?P<date>.+?):\s+(?P<srcaddr>.+?):(?P<srcport>\d+?)\s*-\((?P<proto>.+?)\)->\s*(?P<dstaddr>.+?):(?P<dstport>\d+?)$')
data = None
packet = ''
direction = None
for line in open('../../../.sipclient/logs/sip_trace.txt.0'):
    line = line.strip()
    if second_line:
        second_line = False
        data = second_line_re.match(line).groupdict()
        data['date'] = datetime.strptime(data['date'], '%Y-%m-%d %H:%M:%S.%f')
        data['srcport'] = int(data['srcport'])
        data['dstport'] = int(data['dstport'])
    elif line.startswith('RECEIVED:'):
        direction = 'incoming'
        data = None
        packet = ''
        second_line = True
    elif line.startswith('SENDING:'):
        direction = 'outgoing'
        data = None
        packet = ''
        second_line = True
    elif line == '--':
        pobj = Packet(data['date'], direction, data['srcaddr'], data['srcport'], data['dstaddr'], data['dstport'], data['proto'], packet)
        index.index_doc(pobj.id, pobj.packet)
        root['packets'][pobj.id] = pobj
        transaction.commit()
        direction = None
    else:
        packet += line + '\r\n'

conn.close()
