#!/usr/bin/python2.6

import os
import re
import sqlite3
from datetime import datetime

try: os.remove('data.db')
except: pass
conn = sqlite3.connect('data.db')
cursor = conn.cursor()
cursor.execute('CREATE VIRTUAL TABLE sip_trace USING fts3(timestamp, direction, source_address, source_port, destination_address, destination_port, protocol, packet)')

second_line = False
second_line_re = re.compile(r'^(?P<date>.+?):\s+(?P<srcaddr>.+?):(?P<srcport>\d+?)\s*-\((?P<proto>.+?)\)->\s*(?P<dstaddr>.+?):(?P<dstport>\d+?)$')
data = None
packet = ''
direction = None
for line in open('../../../.sipclient/logs/sip_trace.txt.0'):
    line = line.strip()
    if second_line:
        second_line = False
        data = second_line_re.match(line).groupdict()
        data['date'] = datetime.strptime(data['date'], '%Y-%m-%d %H:%M:%S.%f')
        data['srcport'] = int(data['srcport'])
        data['dstport'] = int(data['dstport'])
    elif line.startswith('RECEIVED:'):
        direction = 'incoming'
        data = None
        packet = ''
        second_line = True
    elif line.startswith('SENDING:'):
        direction = 'outgoing'
        data = None
        packet = ''
        second_line = True
    elif line == '--':
        cursor.execute('INSERT INTO sip_trace (timestamp, direction, source_address, source_port, destination_address, destination_port, protocol, packet) VALUES (?, ?, ?, ?, ?, ?, ?, ?)',
                       (data['date'], direction, data['srcaddr'], data['srcport'], data['dstaddr'], data['dstport'], data['proto'], packet))
        direction = None
    else:
        packet += line + '\r\n'

conn.commit()
conn.close()
