#!/usr/bin/python

import WSDL
from pprint import pprint

soap_auth = dict(username='myusername', password='mypassword')
wsdl = 'https://secure.dns-hosting.info/ngnpro/wsdl'

sip_port = WSDL.Proxy(wsdl, port='SipPort', auth=soap_auth)
dns_port = WSDL.Proxy(sip_port._wsdl, port='DnsPort', auth=soap_auth)

sip_domains = sip_port.getDomains(query={'filter': {'domain': ''}, 'range': {'start': 0, 'count': 5}})
dns_zones = dns_port.getZones(query={'filter': {'name': ''}, 'range': {'start': 0, 'count': 3}})

print "First 5 SIP domains:"
pprint(sip_domains)
print ""
print "First 3 DNS zones:"
pprint(dns_zones)
print ""

